class Inv_GotFrozen extends Inventory;

var Pawn 	InstigatedBy;
var bool 	bFrozen;
var int		FrozenTime;
var UT_ShieldBeltEffect MyEffect;

event Destroyed() 
{
	if ( MyEffect != None )
		MyEffect.Destroy();
		
	super.Destroyed();
}

function Activate()
{
	MyEffect = Spawn(class'UT_ShieldBeltEffect', Owner,,Owner.Location, Owner.Rotation); 
	MyEffect.Mesh = Owner.Mesh;
	MyEffect.DrawScale = Owner.Drawscale;
	MyEffect.ScaleGlow = 0.5;
	MyEffect.Texture = FireTexture'UnrealShare.Belt_fx.ShieldBelt.Blueshield';
	MyEffect.LowDetailTexture = Texture'UnrealShare.Belt_fx.ShieldBelt.newblue';
	if ( PBPRI(PlayerPawn(InstigatedBy).PlayerReplicationInfo).NaliLevel == 0 )
		Pawn(Owner).AirSpeed *= 0.75;
	else if ( PBPRI(PlayerPawn(InstigatedBy).PlayerReplicationInfo).NaliLevel == 1 )
		Pawn(Owner).AirSpeed *= 0.5;
	else if ( PBPRI(PlayerPawn(InstigatedBy).PlayerReplicationInfo).NaliLevel == 2 )
		Pawn(Owner).AirSpeed *= 0.25;
	else if ( PBPRI(PlayerPawn(InstigatedBy).PlayerReplicationInfo).NaliLevel == 3 )
		{
		Pawn(Owner).AirSpeed *= 0;
		bFrozen = True;
		FrozenTime = 5;
		Balloon(Owner).bFrozen = True;
		}
	SetTimer(1.0, true);
}


function Timer()
{
	if ( bFrozen )
		{
		if ( FrozenTime > 0 )
			{
			FrozenTime -= 1;
			}
		else
			{
			bFrozen = False;
			Pawn(Owner).AirSpeed = (Balloon(Owner).BaseSpeed * Balloon(Owner).speed) * 0.25;
			Balloon(Owner).bFrozen = False;
			}
		}
} 

defaultproperties
{
bFrozen=False
FrozenTime=0
}
